
//
// To jest przykadowy kod z podrozdziau 10.4 Otwieranie pliku ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include <fstream>
#include <string>
#include "std_lib_facilities.h"

using namespace std;

//------------------------------------------------------------------------------

struct Point
{
    int x;
    int y;

    friend istream& operator>>(istream& ist, Point& p)
    {
        char a,b,c;

        if ((ist >> a >> p.x >> b >> p.y >> c) && !(a == '(' && b == ',' && c == ')'))
            throw runtime_error("Nieprawidowy format");

        return ist;
    }

    friend ostream& operator<<(ostream& ost, const Point& p)
    {
        return ost << '(' << p.x << ',' << p.y << ')' << endl;
    }
};

//------------------------------------------------------------------------------

int main()
try
{
    cout << "Podaj nazw pliku wyjciowego: ";
    string name;
    cin >> name;
    ofstream ost(name.c_str());    // ost jest strumieniem wyjciowym dla pliku o nazwie oname.
    if (!ost) error("Nie mona otworzy pliku wyjciowego. ",name);

    vector<Point> points;

    for (int i = 0; i < 10; ++i)
    {
        Point p = {i, i*i};
        points.push_back(p);
    }

    for (int i=0; i<points.size(); ++i)
        ost << '(' << points[i].x << ',' << points[i].y << ")\n";
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
};

//------------------------------------------------------------------------------

void fill_from_file(vector<Point>& points, string& name)
{
    ifstream ist(name.c_str());    // Otwiera plik do odczytu.
    if (!ist) error("Nie mona otworzy pliku wejciowego ",name);
    //  uycie ist 
    // Plik zostanie automatycznie zamknity po zakoczeniu funkcji.
}

//------------------------------------------------------------------------------
